viewer.mode=OVERLAY

function setup()
    print("reorder tabs to see different versions")
    tab1={3,9,27,81}
    parameter.action("nxt",nxt)    
    colr={color(255,0,0),color(0,255,0),
    color(0,255,255),color(255,255,0)}
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene() 
    v=scene.camera:add(OrbitViewer,vec3(50,50,50), 8, 0, 1000)
    
    setLighting()
    
    v.rx=30
    v.ry=30
    count=-1
    entity = scene:entity()
    volume = entity:add(craft.volume, 200, 200, 200)
    ss=3
    val=1
    cube(0,0,0,3)  
end

function setLighting()
    scene.sun.rotation = quat.eulerAngles(45,0,45)   
    scene.ambientColor = color(47)   
    skyMaterial = scene.sky.material
    skyMaterial.horizon = color(84, 208, 201)    
    cameraComponent = scene.camera:get(craft.camera)
    cameraComponent.hdr = true
    cameraComponent.colorTextureEnabled = true
    sunLight = scene.sun:get(craft.light)
    sunLight.intenstity =  800
end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw()  
end

function nxt()   
    clr=true
    cube(0,0,0,ss)
    val=val+1
    if val>4 then
        val=1
        v.zoom=3
    end
    ss=tab1[val]
    clr=false
    cube(0,0,0,ss)
    v.zoom=v.zoom*2.8
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        count=count+1
                        if count%20==0 then
                            colr=color(math.random(255),math.random(255),math.random(255))
                        end
                        if size ~= 3 then
                            volume:set((x1+x+50), (y1+y+50), (z1+z+50), 'name', 'empty')
                        else
                            volume:set((x1+x+50), (y1+y+50), (z1+z+50), 'name', 'solid', 'color', colr)
                        end
                    end
                end
            end            
        end
    end
end   